#include <mios32.h>
#include <seq_bpm.h>
#include "seq.h"
#include "app.h"

static s32 SEQ_Tick(u32 bpm_tick);
static u8 seq_pause  = 0;       // pause mode (will be controlled from user interface)
static u16 setPpqnDivider = 8;  // to be shure that the 16th-PPQM-divider is changed in main-sync
       s16 TicSend   = 0;
       u8 StepOffset = 0;       // Number off steps to delayd (in Order to get better in sync with other hardware)
        
s32 SEQ_Init(u32 mode){
    
    //initalize 1st Clip with standart values

        loop[0].leader =  0;   
        loop[0].virgin =  1;
        loop[0].length =  1;
        loop[0].decay =  60; //maximal 256 since we use u8 integer type
        loop[0].rythm =   4;
        loop[0].bpm   = 120;
        
        loop[1].leader =  0;   
        loop[2].virgin =  1;
        loop[3].length =  1;
        loop[4].decay =  60; //maximal 256 since we use u8 integer type
        loop[5].rythm =   4;
        loop[6].bpm   = 120;  
              
        //initiate Pitchbend
        u16 b; for(b=0; b<512; b++)   { loop[0].PB[b] = 8192; }    // 8192: inital No Pitchbend! 

            
    SEQ_Reset();  // reset sequencer
    SEQ_BPM_Init(0);  // init loop[c].bpm generator
    SEQ_BPM_PPQN_Set(Tic);
    SEQ_BPM_Set(loop[ActualSEQ].bpm);
    SEQ_BPM_TickSet(0); 
  return 0; // no error
}

s32 SEQ_Handler(void){ // this sequencer handler is called periodically to check for new requests from loop[c].bpm generator
  // handle requests

  u8 num_loops = 0;
  u8 again = 0;
  do {
    ++num_loops;

    // note: don't remove any request check - clocks won't be propagated
    // so long any Stop/Cont/Start/SongPos event hasn't been flagged to the sequencer
    if ( SEQ_BPM_ChkReqStop() ) {
     // SEQ_PlayOffEvents();
    }

    if ( SEQ_BPM_ChkReqCont() ) {
      // release pause mode
      seq_pause = 0;
    }

    if ( SEQ_BPM_ChkReqStart() ) {
      SEQ_Reset();
    }

    u16 new_song_pos;
    if ( SEQ_BPM_ChkReqSongPos(&new_song_pos) ) {
   //   SEQ_PlayOffEvents();
    }

    u32 bpm_tick;
    if ( SEQ_BPM_ChkReqClk(&bpm_tick) > 0 ) {
      again = 1; // check all requests again after execution of this part

      SEQ_Tick(bpm_tick);
    }
  } while( again && num_loops < 10 );

  return 0; // no error
}

s32 SEQ_Reset(void){
  seq_pause = 0;   // release pause mode
  SEQ_BPM_TickSet(0);   // reset loop[c].bpm tick
  return 0; // no error
}

s32 SEQ_Loop(void){return 0;}


static s32 SEQ_Tick(u32 bpm_tick){  // performs a single bpm tick
    
  //MAIN RESET ON FIRST TIC EVER... (PLAY-Button)
  if ( bpm_tick == 0 ) { main_step_pos = -1;
                        loop_step_pos[0] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[1] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[2] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[3] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[4] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[5] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[6] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[7] = StepOffset;}


  //96tic loop
  TicSend = (bpm_tick % (SEQ_BPM_PPQN_Get()/setPpqnDivider));

  //Step-Count --Running Light
  if (TicSend == 0 ) { // whenever we reach a new 16th note (e.g 96 tics @384 ppqn):
         //MAIN LOOP COUNTER
         if ( ++main_step_pos >= MainLoop ) main_step_pos = 0; // increment step number until it reaches the mainloop loop[c].length of a page /tact system


         //Set new Loop (in Main Sync)
         if (main_step_pos == 0) {
             
              if (NeedSync == 1){//Something has changed, Set new Loop point when MainLoop is finished
                   NeedSync = 3; //New NeedSync to avoid double triggering events.
                   //set new step position 
                    loop_step_pos[0] = StepOffset;
                    loop_step_pos[1] = StepOffset;
                    loop_step_pos[2] = StepOffset;
                    loop_step_pos[3] = StepOffset;
                    loop_step_pos[4] = StepOffset;
                    loop_step_pos[5] = StepOffset;
                    loop_step_pos[6] = StepOffset;
                    loop_step_pos[7] = StepOffset;}                 

              if (NeedSync == 4) {
                 SEQ_BPM_PPQN_Set(Tic); //set TICs (normally 384)
                 NeedSync = 3;} //New NeedSync to avoid double triggering events.

              if (NeedSync == 5) {
                 setPpqnDivider = PpqnDivider; //set PPQN Divider in time
                 NeedSync = 3;} //New NeedSync to avoid double triggering events
        }

//Avoid Additional Counter ++ after giving new Loop Step Positions
	       if (NeedSync != 3) { 
                                if ( ++loop_step_pos[0] >= (loop[0].length * MainLoop))    loop_step_pos[0] = StepOffset;
                                if ( ++loop_step_pos[1] >= (loop[1].length * MainLoop))    loop_step_pos[1] = StepOffset;
                                if ( ++loop_step_pos[2] >= (loop[2].length * MainLoop))    loop_step_pos[2] = StepOffset;
                                if ( ++loop_step_pos[3] >= (loop[3].length * MainLoop))    loop_step_pos[3] = StepOffset;
                                if ( ++loop_step_pos[4] >= (loop[4].length * MainLoop))    loop_step_pos[4] = StepOffset;
                                if ( ++loop_step_pos[5] >= (loop[5].length * MainLoop))    loop_step_pos[5] = StepOffset;
                                if ( ++loop_step_pos[6] >= (loop[6].length * MainLoop))    loop_step_pos[6] = StepOffset;
                                if ( ++loop_step_pos[7] >= (loop[7].length * MainLoop))    loop_step_pos[7] = StepOffset;}
           //Reset Syncflac
	       if (NeedSync == 3) { NeedSync = 0;}
           
           
     //LEDRING Loop Position Indication
        if ( ( mute[0] == 1) || (REC[0] == 1) ) {
               IND[0] = (((10000*loop_step_pos[0]) / (MainLoop * loop[0].length)) * 16)/10000;} //show Loop Position on a LED-RING 
    
        if ( ( mute[1] == 1) || (REC[1] == 1) ) {
               IND[1] = (((10000*loop_step_pos[1]) / (MainLoop * loop[1].length)) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if ( ( mute[2] == 1) || (REC[2] == 1) ) {
               IND[2] = (((10000*loop_step_pos[2]) / (MainLoop * loop[2].length)) * 16)/10000;} //show Loop Position on a LED-RING 
            
    
        if ( ( mute[3] == 1) || (REC[3] == 1) ) {
               IND[3] = (((10000*loop_step_pos[3]) / (MainLoop * loop[3].length)) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if ( ( mute[4] == 1) || (REC[4] == 1) ) {
               IND[4] = (((10000*loop_step_pos[4]) / (MainLoop * loop[4].length)) * 16)/10000;} //show Loop Position on a LED-RING 
        
        if ( ( mute[5] == 1) || (REC[5] == 1) ) {
               IND[5] = (((10000*loop_step_pos[5]) / (MainLoop * loop[5].length)) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if ( ( mute[6] == 1) || (REC[6] == 1) ) {
               IND[6] = (((10000*loop_step_pos[6]) / (MainLoop * loop[6].length)) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if ( ( mute[7] == 1) || (REC[7] == 1) ) {
               IND[7] = (((10000*loop_step_pos[7]) / (MainLoop * loop[7].length)) * 16)/10000;} //show Loop Position on a LED-RING 
   
   
} //END "If Tic=0"...

REC_PLAY(0, 127, 0, main_step_pos, TicSend); //(u8 port, u8 note, u16 velocity, u8 step) Back to APP.c
    return 0; // no error 
}
